%% GMM demo
% Copyright 2017: Steven Van Kuyk
% This program comes WITHOUT ANY WARRANTY.
%
% Demonstration of how to generate random data and fit a GMM
% Written by Steven Van Kuyk, 2017
clear all;
close all;
clc;

% generate random data
D=2; % number of dimensions
K=6; % number of clusters
N=4e3; % number of data points
[x,gmm_true] = GMMrand(N,D,K,[],[],[]);

figure(5)
plot(x(1,:),x(2,:),'.')
title('training data')
xlabel('dimension 1')
ylabel('dimension 2')
pause(1)

% train using EM
[gmm1, llh] = GMM_EM(x,K,true);

% train using VI
[gmm2, L] = GMM_VI(x,K,true);