%% Griffin and Lim Demo
% Copyright 2017: Steven Van Kuyk
% This program comes WITHOUT ANY WARRANTY.
%
% Synthesize speech from short-time magnitude spectra (i.e., no phase
% information) using the Griffin & Lim 1984 algorithm. 
clc
clear all
fs = 16000;
window_size = 512;
step_size = 128;

% get short-time magnitude spectra
[x_original, Fs] = audioread('clean.wav');
x_original = resample(x_original,fs,Fs);
[stft,t,f] = STFT(x_original,window_size,step_size,fs);
Y = abs(stft); % magnitude spectrum

% apply algorithm from Griffin & Lim 1984, section III to obtain speech
x_istft = randn(size(x_original)); % initial estimate of speech signal
for i=1:100 % number of iterations
    X = STFT(x_istft,window_size,step_size,fs);
    x_istft = ISTFT(Y.*exp(1j*angle(X)),window_size,step_size); % substitute magnitude spectrum and apply istft
end

%--------plots
% note that the two signals are not the same. This is because there is no
% unique solution to inverting a magnitude spectrum. However, perceptually
% there is almost no difference between the signals.
figure(1)
imagesc(t,f,log(abs(stft)))
set(gca,'ydir','normal')
title('target magnitude spectrum')

figure(2)
plot((1:length(x_original))/fs,x_original, (1:length(x_istft))/fs,x_istft,':')
legend('original signal', 'synthesized signal')

sound([x_original; x_istft],fs) 
